/**
  Copyright (c) 2010 Freescale Semiconductor
  Freescale Confidential Proprietary
  
  \file  	  FontLibrary.h
  \brief	  This is the Font Library Driver header File
  \brief	  Library for rendering text from Freescale Font files
  \brief	  Uses DMA for memory transfers. Supports 8bpp
  \author	  Freescale Semiconductor
  \author	  MSG
  \author	  IM, b06623
  \version	  2.0
  \revision	  $Revision: 21 $
  \date  	  $Date: 2010-09-09 19:26:09 -0500 (Thu, 09 Sep 2010) $  

* Copyright (c) 2010, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
  
*/


#ifndef 	_FONTLIBRARY_H_
#define  	_FONTLIBRARY_H_	 

#include	 "Graphics.h"

/******************** Font Library Driver Data Types  ************************/

typedef  enum
{
	FONT_FREERUN,
	FONT_VBLANK,
	FONT_LSBFVS,
	FONT_THROTTLED
} Font_ModeType;

typedef  enum
{
	FONT_ASCII,
	FONT_UNICODE
} Font_EncodingType;

typedef  enum
{
	FONT_LEFT,
	FONT_CENTER,
	FONT_RIGHT
} Font_JustifyType;

typedef  enum
{
	FONT_HORIZONTAL,
	FONT_VERTICAL
} Font_OrientationType;

typedef  enum
{
	FONT_DMA,
	FONT_CPU,
	FONT_KERNED
} Font_EngineType;

typedef  enum
{
	FONT_8BPP, 
	FONT_4BPP,
	FONT_2BPP,
	FONT_1BPP
} Font_FormatType;

typedef  enum
{
	FONT_ERROR_OK, 
	FONT_ERROR_FAIL
} Font_ErrorType;

typedef struct
{
    const uint8_t  pixelWidth;
    const uint8_t* glyphAddress;    
} Font_GlyphType;

typedef struct
{
    const uint16_t x;
    const uint16_t y;
    const uint16_t width;
    const uint16_t height;
    const int16_t xoffset;
    const int16_t yoffset;
    const int16_t xadvance; 
} Font_KerningDataType;

typedef  uint16_t(*Font_MapType)(uint16_t  unicodeChar);

typedef struct
{
    const uint16_t height;
    const Font_MapType mapFunction;
    const Font_GlyphType* GlyphSet;
    const Font_GlyphType* GlyphSetShift;
    const Font_FormatType format;
    const Font_KerningDataType* kerningData;
} Font_FontType;

typedef  void  ( * Font_CallbackType )( void  );

/*********************** Configuration Parameters ****************************/

#define  FONT_BUFFERSIZE  (400u)

/************************ Public Functions **********************************/
void Font_Init(void);
void Font_SetLines(uint16_t lines);

Font_ErrorType Font_Print
(
	uint8_t eDMAChannel, Graphics_Object_t*  g_object,
	void* string, uint8_t length, Font_FontType* font, Font_EncodingType code,
	Font_ModeType mode, Font_OrientationType orientation, Font_JustifyType justify,
	Font_CallbackType callback, int16_t xoffset, uint16_t yoffset
);

void Font_PrintCPU
(
	Graphics_Object_t*  g_object, void* string, uint8_t length,
	Font_FontType* font, Font_EncodingType code, Font_ModeType mode, 
	Font_OrientationType orientation, Font_JustifyType justify, int16_t xoffset, uint16_t yoffset
);

void Font_CPU_PrintMachine(uint8_t nChars);
uint16_t Font_StringWidth(void* string, uint8_t length, Font_FontType* font, Font_EncodingType code, Font_EngineType eng);


/************************ Private Functions **********************************/


#endif /* #define _FONTLIBRARY_H_ */ 
